var versionNumber = '1.02';

var cubeState = new Array(54);
var clickSquareArray = new Array(27);

var shouldShowMirrors = false;
var showMirrorState = -1;
var MIRROR_STATE_WHILE_ACTIVE = 1;
var MIRROR_STATE_ALWAYS = 2;
var MIRROR_STATE_NEVER = 3;

var appearanceState = -1;
var APPEARANCE_PRISTINE = 1;
var APPEARANCE_WORN = 2;

var colorSchemes = [
	{ name: "Cool",			R: { r:11/255, g:121/255, b:161/255 },
								Y: { r:15/255, g:33/255, b:139/255 },
								B: { r:106/255, g:61/255, b:154/255 },
								W: { r:78/255, g:182/255, b:145/255 },
								G: { r:255/255, g:255/255, b:0/255 },
								O: { r:199/255, g:96/255, b:173/255 }
	}							
	,{ name: "Tropical",		R: { r:179/255, g:220/255, b:16/255 },
								Y: { r:77/255, g:69/255, b:15/255 },
								B: { r:255/255, g:127/255, b:0/255 },
								W: { r:250/255, g:47/255, b:14/255 },
								G: { r:1/255, g:143/255, b:95/255 },
								O: { r:202/255, g:138/255, b:7/255 }
	}
	,{ name: "Easter",			R: { r:255/255, g:255/255, b:104/255 },
								Y: { r:187/255, g:255/255, b:117/255 },
								B: { r:178/255, g:128/255, b:255/255 },
								W: { r:255/255, g:150/255, b:230/255 },
								G: { r:150/255, g:202/255, b:255/255 },
								O: { r:255/255, g:186/255, b:82/255 }
	}							
	,{ name: "Japanese",		R: { r:190/255, g:49/255, b:114/255 },
								Y: { r:91/255, g:2/255, b:97/255 },
								B: { r:155/255, g:177/255, b:119/255 },
								W: { r:107/255, g:121/255, b:134/255 },
								G: { r:212/255, g:122/255, b:41/255 },
								O: { r:57/255, g:90/255, b:32/255 }
	}							
	,{ name: "Juicy",			R: { r:175/255, g:48/255, b:149/255 },
								Y: { r:251/255, g:52/255, b:46/255 },
								B: { r:254/255, g:153/255, b:41/255 },
								W: { r:247/255, g:79/255, b:133/255 },
								G: { r:179/255, g:221/255, b:61/255 },
								O: { r:83/255, g:77/255, b:161/255 }
	}							
	,{ name: "Exotic",			R: { r:230/255, g:244/255, b:30/255 },
								Y: { r:242/255, g:50/255, b:108/255 },
								B: { r:102/255, g:92/255, b:32/255 },
								W: { r:136/255, g:32/255, b:52/255 },
								G: { r:61/255, g:0/255, b:100/255 },
								O: { r:52/255, g:173/255, b:160/255 }
	}							
	,{ name: "Chic",			R: { r:227/255, g:123/255, b:114/255 },
								Y: { r:229/255, g:221/255, b:191/255 },
								B: { r:56/255, g:69/255, b:102/255 },
								W: { r:0/255, g:0/255, b:0/255 },
								G: { r:228/255, g:122/255, b:60/255 },
								O: { r:153/255, g:172/255, b:153/255 }
	}							
	,{ name: "Starlight",		R: { r:0/255, g:24/255, b:127/255 },
								Y: { r:98/255, g:119/255, b:196/255 },
								B: { r:143/255, g:167/255, b:255/255 },
								W: { r:255/255, g:255/255, b:168/255 },
								G: { r:218/255, g:218/255, b:218/255 },
								O: { r:0/255, g:0/255, b:0/255 }
	}
	,{ name: "Jewel",			R: { r:94/255, g:0/255, b:0/255 },
								Y: { r:128/255, g:105/255, b:0/255 },
								B: { r:0/255, g:0/255, b:74/255 },
								W: { r:66/255, g:59/255, b:51/255 },
								G: { r:25/255, g:82/255, b:138/255 },
								O: { r:0/255, g:48/255, b:18/255 }
	}
	,{ name: "Apple Six-Color",	R: { r:0.8, g:0, b:0 },
								Y: { r:1, g:0.8, b:0 },
								B: { r:0, g:0, b:.6 },
								W: { r:.85, g:.3, b:0 },
								G: { r:.4, g:.64, b:0 },
								O: { r:0, g:.5, b:.7 }
	}
/*	
	,{ name: "Traditional",		R: { r:0.8, g:0, b:0 },
								Y: { r:1, b:0, g:0.8 },
								B: { r:0, g:0, b:.6 },
								W: { r:.9, g:.9, b:.9 },
								G: { r:0, g:.4, b:0 },
								O: { r:.85, g:.3, b:0 }
	}
*/
];
var colorSchemeNumber = 0;

var cubeLocX = 151;
var cubeLocY = 45.5;

// DEFINE THE CUBE CHANGE LOG.
var cubeChangeLog = new Object();
cubeChangeLog.log = "";
cubeChangeLog.numEntries = methodNumEntries;
cubeChangeLog.addEntry = methodAddEntry;
cubeChangeLog.replaceMostRecentEntry = methodReplaceMostRecentEntry;
cubeChangeLog.deleteMostRecentEntry = methodDeleteMostRecentEntry;
cubeChangeLog.getMostRecentEntry = methodGetMostRecentEntry;
cubeChangeLog.getEntryCommand = methodGetEntryCommand;
cubeChangeLog.clear = methodClear;
cubeChangeLog.optimize = methodOptimize;
cubeChangeLog.getOppositeEntry = methodGetOppositeEntry;

function methodNumEntries() {
	return this.log.length / 4;
}
function methodAddEntry( entry ) {
	if ( entry.length == 4 ) {
		this.log += entry;
	}
	else {
		alert( "INCORRECT ENTRY LENGTH; ENTRY = " + entry );
	}
}
function methodReplaceMostRecentEntry( num, entry ) {
	if ( entry.length == 4 ) {
		var entryPos = this.log.length - ( num*4 );
		this.log = this.log.substring( 0, entryPos ) + entry + this.log.substring( entryPos+4, this.log.length );
	}
	else {
		alert( "INCORRECT ENTRY LENGTH; ENTRY = " + entry );
	}	
}
function methodDeleteMostRecentEntry( num ) {
	if ( num <= this.numEntries() ) {
		var entryPos = this.log.length - (num * 4);
		this.log = this.log.substring( 0, entryPos ) + this.log.substring( entryPos+4, this.log.length );
	}
}
function methodGetMostRecentEntry( num ) {
	if ( num == null ) return( null );
	if ( num < 1 ) return( null );
	if ( num > this.numEntries() ) return( null );
	var entryPos = this.log.length - (num * 4);
	var returnValue = this.log.substring( entryPos, entryPos + 4 );
	return( returnValue );
}
function methodGetEntryCommand( logEntry ) {
	return( logEntry.substring( 0, 2 ) );
}
function methodClear() {
	this.log = "";
}
function methodOptimize() {

	// Look for palindromes.
	var curEntryNum = 1;
	while( curEntryNum < this.numEntries() ) {
		var curEntry = this.getMostRecentEntry( curEntryNum );
		if ( this.getOppositeEntry( curEntry ) == this.getMostRecentEntry( curEntryNum+1 ) ) {
			this.deleteMostRecentEntry( curEntryNum );
			this.deleteMostRecentEntry( curEntryNum );
			curEntryNum = ( curEntryNum == 1 ) ? 1 : curEntryNum-1;
		}
		else {
			curEntryNum++;
		}
	}

	// Look for threes and fours.
	var failsafe = 0;
	curEntryNum = 1;
	while ( curEntryNum < this.numEntries() ) {
		var mostRecentEntry = this.getMostRecentEntry( curEntryNum );
		var matches = 0;
		do {
			if ( this.getMostRecentEntry( curEntryNum+1+matches ) != mostRecentEntry ) {
				break;
			}
			matches++;
		} while ( matches < 3 )
		if ( matches == 3 ) {
			// Look back four records and see if they're identical. If they are, they can be wiped out.
			this.deleteMostRecentEntry( curEntryNum );
			this.deleteMostRecentEntry( curEntryNum );
			this.deleteMostRecentEntry( curEntryNum );
			this.deleteMostRecentEntry( curEntryNum );
		}
		else if ( matches == 2 ) {
			// Look back three records and see if they're identical. If they are, they
			// can be replaced by one "opposite" command.
			switch( this.getEntryCommand( mostRecentEntry ) ) {
				case "RF":
					this.replaceMostRecentEntry( curEntryNum, this.getOppositeEntry( mostRecentEntry ) );
					break;
				case "RC":
					var fromFace = mostRecentEntry.charAt( 2 );
					var toFace = mostRecentEntry.charAt( 3 );
					this.replaceMostRecentEntry( curEntryNum, this.getOppositeEntry( mostRecentEntry ) );
					break;
				default:
					alert( "Invalid change log command! " );
					break;
			}
			this.deleteMostRecentEntry( curEntryNum+1 );
			this.deleteMostRecentEntry( curEntryNum+1 );
		}
		else {
			curEntryNum++;
		}
	}
}
function methodGetOppositeEntry( entry ) {
	var oppositeEntry;
	switch( this.getEntryCommand( entry ) ) {
		case "RF":
			var direction = entry.charAt( 3 );
			var oppositeDirection = ( direction == '0' ) ? '1' : '0';
			oppositeEntry = entry.substring( 0, 3 ) + oppositeDirection;
			break;
		case "RC":
			var fromFace = entry.charAt( 2 );
			var toFace = entry.charAt( 3 );
			oppositeEntry = entry.substring( 0, 2 ) + toFace + fromFace;
			break;
		default:
			alert( "Invalid change log command! " );
			break;
	}
	return( oppositeEntry );
}

function initialize() {
	if (window.widget)
	{
		widget.onhide = onhide;
		widget.onshow = onshow;
		widget.onremove = onremove;
	}

	// Check for update.
	// checkForUpdate();  // Doesn't work in Tiger, apparently.
	
	createClickArrays();
	positionClickArrays();
	resetCube();
	loadPreferences();
	drawCube();
	
	// Set up UI gadgets.
	gadget = document.getElementById('showMirrorStateGadget');
	gadget.options.length = 0;
	gadget.options[0] = new Option("Only while active", MIRROR_STATE_WHILE_ACTIVE, true, false );
	gadget.options[1] = new Option("Always", MIRROR_STATE_ALWAYS, false, false );
	gadget.options[2] = new Option("Never", MIRROR_STATE_NEVER, false, false );

	appearanceGadget.options.length = 0;
	appearanceGadget.options[0] = new Option( "Pristine", APPEARANCE_PRISTINE, true, false );
	appearanceGadget.options[1] = new Option( "Worn", APPEARANCE_WORN, false, false );
	
	for ( var i = 0; i < colorSchemes.length; i++ ) {
		colorSchemeGadget.options[i] = new Option( colorSchemes[i].name, i, false, false );
	}
}

function loadPreferences() {
	if ( window.widget ) {
		showMirrorState = widget.preferenceForKey( createKey( "showMirrorState" ) );
		if ( ! showMirrorState ) {
			showMirrorState = MIRROR_STATE_WHILE_ACTIVE;
		}
		shouldShowMirrors = ( showMirrorState != MIRROR_STATE_NEVER )
		appearanceState = widget.preferenceForKey( createKey( "appearanceState" ) );
		if ( ! appearanceState ) {
			appearanceState = APPEARANCE_PRISTINE;
		}
		var colorSchemeName = widget.preferenceForKey( createKey( "colorSchemeName" ) );
		colorSchemeNumber = 0;
		for ( var i = 0; i < colorSchemes.length; i++ ) {
			if ( colorSchemeName == colorSchemes[i].name ) {
				colorSchemeNumber = i;
				break;
			}
		}
		
		if ( widget.preferenceForKey( createKey( "cubeChangeLog" ) ) ) {
			cubeChangeLog.log = widget.preferenceForKey( createKey( "cubeChangeLog" ) );
		}
		
		// Convert the cube state from a string back into an array.
		var cubeStateString = widget.preferenceForKey( createKey( "cubeState" ) );
		if ( cubeStateString ) {
			for ( i = 0; i < 54; i++ ) {
				cubeState[i] = cubeStateString.charAt( i );
			}
		}
	}
}

function savePreferences() {
	if ( window.widget ) {
		widget.setPreferenceForKey( showMirrorState, createKey( "showMirrorState" ) );
		widget.setPreferenceForKey( appearanceState, createKey( "appearanceState" ) );
		widget.setPreferenceForKey( colorSchemes[colorSchemeNumber].name, createKey( "colorSchemeName" ) );
		widget.setPreferenceForKey( cubeChangeLog.log, createKey( "cubeChangeLog" ) );
		
		// Convert the cube state into a string.
		var cubeStateString = "";
		for ( i = 0; i < 54; i++ ) {
			cubeStateString += cubeState[i];
		}
		widget.setPreferenceForKey( cubeStateString, createKey( "cubeState" ) );
	}
}

// Set the mirrors & controls to the correct state.
function onfocus() {
	shouldShowMirrors = ( showMirrorState != MIRROR_STATE_NEVER );
	controls.style.visibility = 'visible';
//	fade( controls, 0, 1, 300, null );
	drawCube();
}

function onblur() {
	stopDrag( null );
	shouldShowMirrors = ( showMirrorState == MIRROR_STATE_ALWAYS );
	controls.style.visibility = 'hidden';
//	fade( controls, 1, 0, 300, null );
	drawCube();
}

var framerate = 20;
var timer;
function fade( fadeImage, startOpacity, endOpacity, duration, callback ) {
	fadeImage.style.visibility = 'visible';
	fadeImage.style.opacity = startOpacity;
	if ( timer != null ) {
		clearInterval( timer );
		timer = null;
	}
	timer = setInterval( fadeSupport, framerate, fadeImage, startOpacity, endOpacity, duration, callback );
}

function fadeSupport( fadeImage, startOpacity, endOpacity, duration, callback ) {
	var stopIt;
	if ( endOpacity - startOpacity > 0 ) {
		stopIt = ( fadeImage.style.opacity >= endOpacity );
	}
	else {
		stopIt = ( fadeImage.style.opacity <= endOpacity );
	}
	if ( stopIt ) {
		clearInterval( timer );
		timer = null;
		fadeImage.style.opacity = endOpacity;
		if ( fadeImage.style.opacity <= 0 ) fadeImage.style.visibility = 'hidden';
		if ( callback ) callback();
	}
	else {
		opacityChangePerFrame = (endOpacity-startOpacity) / (duration/framerate);
		fadeImage.style.opacity = parseFloat( fadeImage.style.opacity ) + parseFloat( opacityChangePerFrame );
	}
}

function resetB() {
	if ( ! solvingCube ) {
		resetCube();
		drawCube();
	}
}

function scrambleB() {
	if ( ! solvingCube ) {
		scrambleCube();
		drawCube();
	}
}

var fadeInFrameDuration = 100;
var fadeInOpacityIncrement = 0.0;
var fadeInImage = null;
var fadeInTimeToFadeIn = 0;
var fadeInCallbackWhenDone = null;
var fadeInTimer = null;
function fadeIn( image, timeToFadeIn, callbackWhenDone ) {
	fadeInImage = image;
	fadeInTimeToFadeIn = timeToFadeIn;
	fadeInCallbackWhenDone = callbackWhenDone;
	
	fadeInImage.style.opacity = 0;
	fadeInOpacityIncrement = Math.round( 1/(fadeInTimeToFadeIn/fadeInFrameDuration) *100 ) / 100;
	fadeInTimer = setInterval( "fadeInSupport();", fadeInFrameDuration );
}

function solveB() {
	if ( ! solvingCube ) {
		solveCube();
	}
}

function handleButtonMouseover(buttonName) {
	button = document.getElementById( buttonName );
	if ( ! solvingCube ) {
		button.style.opacity = 1;
	}
}

function handleButtonMouseout(buttonName) {
	button = document.getElementById( buttonName );
	if ( ! solvingCube ) {
		button.style.opacity = .4;
	}
}

var flipped = false;
function flip() {
	if ( ! solvingCube ) {
		if ( window.widget ) {
			if ( ! flipped ) {
				widget.prepareForTransition('ToBack');
				widgetFront.style.display = 'none';
				widgetBack.style.display = 'block';
				showMirrorStateGadget.value = showMirrorState;
				appearanceGadget.value = appearanceState;
				colorSchemeGadget.value = colorSchemeNumber;
			}
			else {
				widget.prepareForTransition('ToFront');
				widgetFront.style.display = 'block';
				widgetBack.style.display = 'none';
				showMirrorState = showMirrorStateGadget.value;
				appearanceState = appearanceGadget.value;
				colorSchemeNumber = colorSchemeGadget.value;
				savePreferences();
				loadPreferences();
				
				//re-dim the flip button.
				handleButtonMouseout( 'flipButton' );
			}
			setTimeout( 'widget.performTransition(); drawCube();', 0 );
			flipped = !flipped;
		}
	}
}

function onhide() {
	stopDrag(null);
	savePreferences();
}

function onshow() {
	drawCube();
}

function showAbout() {
	widget.openURL('http://www.c3images.com/dashboard/aboutCube.html?version=' + versionNumber);
}

function resetCube() {
	for ( var i = 0; i < 9; i++ ) {
		cubeState[i] = "W";
	}
	for ( var i = 9; i < 18; i++ ) {
		cubeState[i] = "B";
	}
	for ( var i = 18; i < 27; i++ ) {
		cubeState[i] = "R";
	}
	for ( var i = 27; i < 36; i++ ) {
		cubeState[i] = "O";
	}
	for ( var i = 36; i < 45; i++ ) {
		cubeState[i] = "Y";
	}
	for ( var i = 45; i < 54; i++ ) {
		cubeState[i] = "G";
	}
	
	// We're back to our "starting" point, so erase the cube change log.
	cubeChangeLog.clear()
}

function createClickArrays() {
	// Add an event listener to sides 1 and 2.
	for ( side = 1; side <= 2; side++ ) {
		for ( var i = 0; i < 3; i++ ) {
			for ( var j = 0; j < 3; j++ ) {
				var sideNum = side*9+i*3+j;
				clickSquareArray[sideNum] = document.getElementById("ClickSquare"+sideNum);
				clickSquareArray[sideNum].addEventListener( 'mousedown', startDrag, false );
				clickSquareArray[sideNum].style.opacity = 0;
			}
		}
	}
}

function positionClickArrays() {
	oldCubeLocX = cubeLocX;
	oldCubeLocY = cubeLocY;
	
	cubeLocX = 131;
	cubeLocY = -7;

	// Side 1.
	clickSquareArray[9].style.left = cubeLocX + 19;
	clickSquareArray[9].style.top = cubeLocY + 45;
	clickSquareArray[12].style.left = cubeLocX + 19;
	clickSquareArray[12].style.top = cubeLocY + 88;
	clickSquareArray[15].style.left = cubeLocX + 19;
	clickSquareArray[15].style.top = cubeLocY + 130;

	clickSquareArray[10].style.left = cubeLocX + 49;
	clickSquareArray[10].style.top = cubeLocY + 55;
	clickSquareArray[13].style.left = cubeLocX + 49;
	clickSquareArray[13].style.top = cubeLocY + 97;
	clickSquareArray[16].style.left = cubeLocX + 49;
	clickSquareArray[16].style.top = cubeLocY + 139;

	clickSquareArray[11].style.left = cubeLocX + 79;
	clickSquareArray[11].style.top = cubeLocY + 65;
	clickSquareArray[14].style.left = cubeLocX + 79;
	clickSquareArray[14].style.top = cubeLocY + 107;
	clickSquareArray[17].style.left = cubeLocX + 79;
	clickSquareArray[17].style.top = cubeLocY + 148;
	
	// Side 2.
	clickSquareArray[18].style.left = cubeLocX + 110;
	clickSquareArray[18].style.top = cubeLocY + 63;
	clickSquareArray[21].style.left = cubeLocX + 110;
	clickSquareArray[21].style.top = cubeLocY + 105;
	clickSquareArray[24].style.left = cubeLocX + 110;
	clickSquareArray[24].style.top = cubeLocY + 147;
	
	clickSquareArray[19].style.left = cubeLocX + 139;
	clickSquareArray[19].style.top = cubeLocY + 54;
	clickSquareArray[22].style.left = cubeLocX + 139;
	clickSquareArray[22].style.top = cubeLocY + 96;
	clickSquareArray[25].style.left = cubeLocX + 139;
	clickSquareArray[25].style.top = cubeLocY + 138;
	
	clickSquareArray[20].style.left = cubeLocX + 168;
	clickSquareArray[20].style.top = cubeLocY + 45;
	clickSquareArray[23].style.left = cubeLocX + 168;
	clickSquareArray[23].style.top = cubeLocY + 87;
	clickSquareArray[26].style.left = cubeLocX + 168;
	clickSquareArray[26].style.top = cubeLocY + 129;

	cubeLocX = oldCubeLocX;
	cubeLocY = oldCubeLocY;
}

function rotateCube( fromFace, toFace, skipRecord ) {
	// Record the cube rotation so when we solve the cube, we can undo it.
	if ( ! skipRecord ) {
		cubeChangeLog.addEntry( "RC" + fromFace + toFace );
	}
	
	if ( ( fromFace == 1 ) && ( toFace == 2 ) ) {
		// Turn face 0 counter & 3 clockwise
		rotateFace( 0, false, true );
		rotateFace( 3, true, true );
		rotateFace( 8, false, true );
	}
	else if ( ( fromFace == 0 ) && ( toFace == 1 ) ) {
		rotateFace( 2, false, true );
		rotateFace( 4, true, true );
		rotateFace( 6, false, true );
	}
	else if ( ( fromFace == 0 ) && ( toFace == 2 ) ) {
		rotateFace( 1, true, true );
		rotateFace( 5, false, true );
		rotateFace( 7, true, true );
	}
	else if ( ( fromFace == 2 ) && ( toFace == 1 ) ) {
		rotateCube( 1, 2, true );
		rotateCube( 1, 2, true );
		rotateCube( 1, 2, true );
	}
	else if ( ( fromFace == 1 ) && ( toFace == 0 ) ) {
		rotateCube( 0, 1, true );
		rotateCube( 0, 1, true );
		rotateCube( 0, 1, true );
	}
	else if ( ( fromFace == 2 ) && ( toFace == 0 ) ) {
		rotateCube( 0, 2, true );
		rotateCube( 0, 2, true );
		rotateCube( 0, 2, true );
	}
}

function drawCube() {

	// Show/hide the appropriate HTML elements.

	mirrors.style.visibility = ( shouldShowMirrors ) ? 'visible' : 'hidden';
	cubeShadow.style.visibility = ( shouldShowMirrors ) ? 'hidden' : 'visible';
	if ( appearanceState == APPEARANCE_PRISTINE ) {
		cubeWorn.style.visibility = 'hidden';
		cubeWornMirrors.style.visibility = 'hidden';
		face0Reflection.style.visibility = 'visible';
		face1Reflection.style.visibility = 'visible';
		face2Reflection.style.visibility = 'visible';
	}
	else if ( appearanceState == APPEARANCE_WORN ) {
		cubeWorn.style.visibility = 'visible';
		cubeWornMirrors.style.visibility = ( shouldShowMirrors ) ? 'visible' : 'hidden';
		face0Reflection.style.visibility = 'hidden';
		face1Reflection.style.visibility = 'hidden';
		face2Reflection.style.visibility = 'hidden';
	}
	else {
		alert( "Cube - invalid appearance state = " + appearanceState );
		appearanceState = APPEARANCE_PRISTINE; // Fix the problem.
	}

	// Position control bar.
	if ( shouldShowMirrors ) {
		controls.style.position = 'absolute';
		controls.style.top = '280';
	}
	else {
		controls.style.position = 'absolute';
		controls.style.top = '200';
	}

	
	// Draw the cube faces.
	
	var canvas = document.getElementById( "canvas" );
	var context = canvas.getContext( "2d" );
	context.save();
	
	// Clear the drawing space and set up the clipping region.
	context.clearRect( 0, 0, 500, 300 );	
	context.beginPath();
	context.moveTo( 10, 20 );
	context.moveTo( 200, 20 );
	context.lineTo( 235, 0 );
	context.lineTo( 460, 20 );
	context.lineTo( 400, 400 );
	context.lineTo( 70, 400 );
	context.lineTo( 10, 20 );
	context.clip();
	
	var sidesToPaint = ( shouldShowMirrors ) ? 6 : 3;
	for ( var i = 0; i < sidesToPaint; i++ ) {
		for ( var j = 0; j < 9; j++ ) {
			setColor( context, cubeState[i*9+j] );
			var x = j % 3;
			var y = parseInt( j / 3 );
			var squareWidth;
			var squareHeight;
			var slope;
						
			context.save();
			context.translate( cubeLocX, cubeLocY );
			switch( i ) {
				case 0:
				case 3:
					if ( i == 3 ) {
						context.translate( 4, 191 );
						var oldY = y;
						y = x;
						x = oldY;
					}
					squareWidth = 30;
					slope = 9;
					context.translate( x*(squareWidth-1) + y*squareWidth - 1, y*slope - x*slope - 10 );
					drawSquare( context, 0, slope, squareWidth, -1 );
					break;
				case 1:
				case 5:
					if ( i == 5 ) {
						context.translate( 200, -29 );
						y = 2 - y;
					}
					squareWidth = 30;
					squareHeight = 41.5;
					slope = 9;
					context.translate( x*squareWidth, y*squareHeight + (x-1)*slope );
					drawSquare( context, 1, slope, squareWidth, squareHeight );
					break;
				case 2:
				case 4:
					if ( i == 4 ) {
						context.translate( -203, -27 );
						y = 2 - y;
					}
					squareWidth = 28;
					squareHeight = 41.5;
					slope = 9;
					context.translate( 90 + x*squareWidth, y*squareHeight + (1-x)*slope );
					drawSquare( context, 2, slope, squareWidth, squareHeight );
					break;
			}
			context.restore();
		}
	}
	
	if ( shouldShowMirrors ) {
		// Draw non-important cube sides in mirrors.
		context.save();
		context.translate( cubeLocX, cubeLocY );
		var squareWidth, squareHeight, slope;
		
		// Bottom mirror.
		for ( var i = 0; i < 3; i++ ) {
			squareWidth = 30;
			squareHeight = 41.5;
			slope = 9;
			context.save();
			setColor( context, cubeState[15+i] );
			context.translate( i*squareWidth + 3, (i-1)*slope + 190 );		
			drawSquare( context, 1, slope, squareWidth, squareHeight );
			context.restore();
		}
	
		for ( var i = 0; i < 3; i++ ) {
			squareWidth = 28;
			squareHeight = 41.5;
			slope = 9;
			context.save();
			setColor( context, cubeState[24+i] );
			context.translate( 94 + i*squareWidth, (1-i)*slope + 190 );
			drawSquare( context, 2, slope, squareWidth, squareHeight );
			context.restore();
		}
		
		// Left mirror.
		for ( var i = 0; i < 3; i++ ) {
			squareWidth = 30;
			squareHeight = 41.5;
			slope = 9;
			context.save();
			setColor( context, cubeState[9+(i*3)] );
			context.translate( -141, i*squareHeight - 18 );		
			drawSquare( context, 1, slope, squareWidth, squareHeight );
			context.restore();
		}
		
		for ( var i = 0; i < 2; i++ ) {
			squareWidth = 30;
			slope = 9;
			context.save();
			setColor( context, cubeState[i] );
			context.translate( i*(squareWidth-1) - 140, -i*slope - 19 );
			drawSquare( context, 0, slope, squareWidth, squareHeight );
			context.restore();
		}
		
		// Right mirror.
		for ( var i = 0; i < 2; i++ ) {
			squareWidth = 28;
			squareHeight = 41.5;
			slope = 9;
			context.save();
			setColor( context, cubeState[20+(i*3)] );
			context.translate( 290, i*squareHeight - 21 );
			drawSquare( context, 2, slope, squareWidth, squareHeight );
			context.restore();
		}
			
		for ( var i = 1; i < 3; i++ ) {
			squareWidth = 30;
			slope = 9;
			context.save();
			setColor( context, cubeState[i*3+2] );
			context.translate( 2*(squareWidth-1) + i*squareWidth + 142, (i-2)*slope - 21 );
			drawSquare( context, 0, slope, squareWidth, squareHeight );
			context.restore();
		}
		
		context.restore();
	}
	context.restore();
}

function setColor( context, color ) {
	if ( colorSchemes[colorSchemeNumber][color].r != null ) {
		context.setFillColor( colorSchemes[colorSchemeNumber][color].r,
							colorSchemes[colorSchemeNumber][color].g,
							colorSchemes[colorSchemeNumber][color].b,
							1 );
	}
	else {
		context.setFillColor( colorSchemes[colorSchemeNumber][color].c,
							colorSchemes[colorSchemeNumber][color].m,
							colorSchemes[colorSchemeNumber][color].y,
							0, 1 );
	}
}

function drawSquare( context, faceOrientation, slope, squareWidth, squareHeight ) {
	context.beginPath();
	switch( faceOrientation ) {
		case 0:
			context.moveTo( 0, 0 );
			context.lineTo( squareWidth-2, -slope+1 );
			context.lineTo( squareWidth*2-3, 0 );
			context.lineTo( squareWidth-2, slope-1 );
			context.lineTo( 0, 0 );
			break;
		case 1:
			context.moveTo( 0, 0 );
			context.lineTo( squareWidth-1, slope );
			context.lineTo( squareWidth-1, squareHeight+slope-1 );
			context.lineTo( 0, squareHeight-1 );
			context.lineTo( 0, 0 );
			break;
		case 2:
			context.moveTo( 0, slope );
			context.lineTo( squareWidth-1, 0 );
			context.lineTo( squareWidth-1, squareHeight-1 );
			context.lineTo( 0, squareHeight-1+slope );
			context.lineTo( 0, 0 );
			break;
		default:
			alert( "invalid faceOrientation = " + faceOrientation );
			break;
	}
	context.fill();
}

function rotateFace( faceNum, clockwise, skipRecord ) {

	// Record the rotation so that when we solve the cube, we can undo it.
	if ( !skipRecord ) {
		var dirChar = ( clockwise ) ? '1' : '0';
		cubeChangeLog.addEntry( "RF" + faceNum + dirChar );
	}
	
	// Flip the cube if we're moving the back side of the cube.
	// This way, I can do all of these manipulations for just one side of the cube.			
	if ( faceNum >= 6 ) {
		
		// Copy cubeState into new arrays.
		var oldCubeState = new Array( 54 );
		for ( var i = 0; i < 54; i++ ) {
			oldCubeState[i] = cubeState[i];
		}			

		if ( ! clockwise ) {
			switch ( faceNum ) {
				case 6:
					cubeState[1*9+1] = oldCubeState[0*9+5];
					cubeState[1*9+4] = oldCubeState[0*9+4];
					cubeState[1*9+7] = oldCubeState[0*9+3];

					cubeState[3*9+1] = oldCubeState[1*9+1];
					cubeState[3*9+4] = oldCubeState[1*9+4];
					cubeState[3*9+7] = oldCubeState[1*9+7];
			
					cubeState[5*9+1] = oldCubeState[3*9+1];
					cubeState[5*9+4] = oldCubeState[3*9+4];
					cubeState[5*9+7] = oldCubeState[3*9+7];

					cubeState[0*9+5] = oldCubeState[5*9+1];
					cubeState[0*9+4] = oldCubeState[5*9+4];
					cubeState[0*9+3] = oldCubeState[5*9+7];
					break;
			
				case 7:
					rotateFace( 7, true, true );
					rotateFace( 7, true, true );
					rotateFace( 7, true, true );
					break;
				
				case 8:
					cubeState[2*9+3] = oldCubeState[1*9+3];
					cubeState[2*9+4] = oldCubeState[1*9+4];
					cubeState[2*9+5] = oldCubeState[1*9+5];

					cubeState[5*9+3] = oldCubeState[2*9+5];
					cubeState[5*9+4] = oldCubeState[2*9+4];
					cubeState[5*9+5] = oldCubeState[2*9+3];
		
					cubeState[4*9+3] = oldCubeState[5*9+3];
					cubeState[4*9+4] = oldCubeState[5*9+4];
					cubeState[4*9+5] = oldCubeState[5*9+5];

					cubeState[1*9+3] = oldCubeState[4*9+5];
					cubeState[1*9+4] = oldCubeState[4*9+4];
					cubeState[1*9+5] = oldCubeState[4*9+3];
					break;
			}
		}
		else { // Clockwise...
			switch ( faceNum ) {
				case 6:
					rotateFace( 6, false, true );
					rotateFace( 6, false, true );
					rotateFace( 6, false, true );
					break;
				
				case 7:
					cubeState[2*9+1] = oldCubeState[0*9+1];
					cubeState[2*9+4] = oldCubeState[0*9+4];
					cubeState[2*9+7] = oldCubeState[0*9+7];

					cubeState[3*9+5] = oldCubeState[2*9+1];
					cubeState[3*9+4] = oldCubeState[2*9+4];
					cubeState[3*9+3] = oldCubeState[2*9+7];
		
					cubeState[4*9+7] = oldCubeState[3*9+3];
					cubeState[4*9+4] = oldCubeState[3*9+4];
					cubeState[4*9+1] = oldCubeState[3*9+5];

					cubeState[0*9+7] = oldCubeState[4*9+7];
					cubeState[0*9+4] = oldCubeState[4*9+4];
					cubeState[0*9+1] = oldCubeState[4*9+1];
					break;
				
				case 8:
					rotateFace( 8, false, true );
					rotateFace( 8, false, true );
					rotateFace( 8, false, true );
					break;				
			}
		}
	}
	else {
		var flipped = false;
		if ( faceNum > 2 ) {
			flipped = true;
			flipCube();
			faceNum -= 3;
		}
		
		// Copy cubeState into new arrays.
		var oldCubeState = new Array( 54 );
		for ( var i = 0; i < 54; i++ ) {
			oldCubeState[i] = cubeState[i];
		}
	
		if ( clockwise == true ) {

			// Rotate the colors on the face itself.
			cubeState[faceNum*9+2] = oldCubeState[faceNum*9+0];
			cubeState[faceNum*9+5] = oldCubeState[faceNum*9+1];
			cubeState[faceNum*9+8] = oldCubeState[faceNum*9+2];
		
			cubeState[faceNum*9+1] = oldCubeState[faceNum*9+3];
			cubeState[faceNum*9+7] = oldCubeState[faceNum*9+5];
		
			cubeState[faceNum*9+0] = oldCubeState[faceNum*9+6];
			cubeState[faceNum*9+3] = oldCubeState[faceNum*9+7];
			cubeState[faceNum*9+6] = oldCubeState[faceNum*9+8];
		
			// Rotate the colors on the edges.
			if ( faceNum == 0 ) {
				// Face 1 top row goes to face 2 top row...
				cubeState[1*9+0] = oldCubeState[2*9+0];
				cubeState[1*9+1] = oldCubeState[2*9+1];
				cubeState[1*9+2] = oldCubeState[2*9+2];
			
				// Face 2 top row goes to face 5 bottom row...
				cubeState[2*9+0] = oldCubeState[5*9+8];
				cubeState[2*9+1] = oldCubeState[5*9+7];
				cubeState[2*9+2] = oldCubeState[5*9+6];
			
				// Face 5 bottom row goes to face 4 bottom row...
				cubeState[5*9+6] = oldCubeState[4*9+6];
				cubeState[5*9+7] = oldCubeState[4*9+7];
				cubeState[5*9+8] = oldCubeState[4*9+8];
			
				// Face 4 bottom row goes to face 1 top row.
				cubeState[4*9+6] = oldCubeState[1*9+2];
				cubeState[4*9+7] = oldCubeState[1*9+1];
				cubeState[4*9+8] = oldCubeState[1*9+0];										
			}
			else if ( faceNum == 1 ) {
				// Face 0 left row goes to face 2 left row...
				cubeState[2*9+0] = oldCubeState[0*9+0];
				cubeState[2*9+3] = oldCubeState[0*9+3];
				cubeState[2*9+6] = oldCubeState[0*9+6];
			
				// Face 2 left row goes to face 3 top row...
				cubeState[3*9+2] = oldCubeState[2*9+0];
				cubeState[3*9+1] = oldCubeState[2*9+3];
				cubeState[3*9+0] = oldCubeState[2*9+6];

				// Face 3 top row goes to face 4 left row...
				cubeState[4*9+6] = oldCubeState[3*9+0];
				cubeState[4*9+3] = oldCubeState[3*9+1];
				cubeState[4*9+0] = oldCubeState[3*9+2];

				// Face 4 left row goes to face 0 left row.
				cubeState[0*9+0] = oldCubeState[4*9+0];
				cubeState[0*9+3] = oldCubeState[4*9+3];
				cubeState[0*9+6] = oldCubeState[4*9+6];
			}
			else if ( faceNum == 2 ) {
				// Face 0 bottom row goes to face 5 right row...
				cubeState[5*9+8] = oldCubeState[0*9+6];
				cubeState[5*9+5] = oldCubeState[0*9+7];
				cubeState[5*9+2] = oldCubeState[0*9+8];
			
				// Face 5 right row goes to face 3 right row...
				cubeState[3*9+2] = oldCubeState[5*9+2];
				cubeState[3*9+5] = oldCubeState[5*9+5];
				cubeState[3*9+8] = oldCubeState[5*9+8];

				// Face 3 right row goes to face 1 right row...
				cubeState[1*9+2] = oldCubeState[3*9+2];
				cubeState[1*9+5] = oldCubeState[3*9+5];
				cubeState[1*9+8] = oldCubeState[3*9+8];

				// Face 1 right row goes to face 0 bottom row.
				cubeState[0*9+8] = oldCubeState[1*9+2];
				cubeState[0*9+7] = oldCubeState[1*9+5];
				cubeState[0*9+6] = oldCubeState[1*9+8];
			}
			else {
				alert ("********* SOMETHING IS VERY WRONG, faceNum = " + faceNum );
			}
		}
		else {
			// Counter-clockwise...
			// Rotate the colors on the face itself.
			cubeState[faceNum*9+0] = oldCubeState[faceNum*9+2];
			cubeState[faceNum*9+1] = oldCubeState[faceNum*9+5];
			cubeState[faceNum*9+2] = oldCubeState[faceNum*9+8];
		
			cubeState[faceNum*9+3] = oldCubeState[faceNum*9+1];
			cubeState[faceNum*9+5] = oldCubeState[faceNum*9+7];

			cubeState[faceNum*9+6] = oldCubeState[faceNum*9+0];
			cubeState[faceNum*9+7] = oldCubeState[faceNum*9+3];
			cubeState[faceNum*9+8] = oldCubeState[faceNum*9+6];
		
			// Rotate the colors on the edges.
			if ( faceNum == 0 ) {
				// Face 1 top row goes to face 2 top row...
				cubeState[2*9+0] = oldCubeState[1*9+0];
				cubeState[2*9+1] = oldCubeState[1*9+1];
				cubeState[2*9+2] = oldCubeState[1*9+2];
			
				// Face 2 top row goes to face 5 bottom row...
				cubeState[5*9+8] = oldCubeState[2*9+0];
				cubeState[5*9+7] = oldCubeState[2*9+1];
				cubeState[5*9+6] = oldCubeState[2*9+2];
			
				// Face 5 bottom row goes to face 4 bottom row...
				cubeState[4*9+6] = oldCubeState[5*9+6];
				cubeState[4*9+7] = oldCubeState[5*9+7];
				cubeState[4*9+8] = oldCubeState[5*9+8];
			
				// Face 4 bottom row goes to face 1 top row.
				cubeState[1*9+2] = oldCubeState[4*9+6];
				cubeState[1*9+1] = oldCubeState[4*9+7];
				cubeState[1*9+0] = oldCubeState[4*9+8];										
			}
			else if ( faceNum == 1 ) {
				// Face 0 left row goes to face 2 left row...
				cubeState[0*9+0] = oldCubeState[2*9+0];
				cubeState[0*9+3] = oldCubeState[2*9+3];
				cubeState[0*9+6] = oldCubeState[2*9+6];
			
				// Face 2 left row goes to face 3 top row...
				cubeState[2*9+0] = oldCubeState[3*9+2];
				cubeState[2*9+3] = oldCubeState[3*9+1];
				cubeState[2*9+6] = oldCubeState[3*9+0];

				// Face 3 top row goes to face 4 left row...
				cubeState[3*9+0] = oldCubeState[4*9+6];
				cubeState[3*9+1] = oldCubeState[4*9+3];
				cubeState[3*9+2] = oldCubeState[4*9+0];

				// Face 4 left row goes to face 0 left row.
				cubeState[4*9+0] = oldCubeState[0*9+0];
				cubeState[4*9+3] = oldCubeState[0*9+3];
				cubeState[4*9+6] = oldCubeState[0*9+6];
			}
			else if ( faceNum == 2 ) {
				// Face 0 bottom row goes to face 5 right row...
				cubeState[0*9+6] = oldCubeState[5*9+8];
				cubeState[0*9+7] = oldCubeState[5*9+5];
				cubeState[0*9+8] = oldCubeState[5*9+2];
			
				// Face 5 right row goes to face 3 right row...
				cubeState[5*9+2] = oldCubeState[3*9+2];
				cubeState[5*9+5] = oldCubeState[3*9+5];
				cubeState[5*9+8] = oldCubeState[3*9+8];

				// Face 3 right row goes to face 1 right row...
				cubeState[3*9+2] = oldCubeState[1*9+2];
				cubeState[3*9+5] = oldCubeState[1*9+5];
				cubeState[3*9+8] = oldCubeState[1*9+8];

				// Face 1 right row goes to face 0 bottom row.
				cubeState[1*9+2] = oldCubeState[0*9+8];
				cubeState[1*9+5] = oldCubeState[0*9+7];
				cubeState[1*9+8] = oldCubeState[0*9+6];
			}
			else {
				alert ("********* SOMETHING IS VERY WRONG, faceNum = " + faceNum );
			}
		}
	
		if ( flipped ) {
			flipCube();
			faceNum += 3;
		}
	}
}

function flipCube() {
	// Copy cubeState into new arrays.
	var oldCubeState = new Array( 54 );
	for ( var i = 0; i < 54; i++ ) {
		oldCubeState[i] = cubeState[i];
	}
	
	// Do the flip.
	for ( var i = 0; i < 27; i++ ) {
		cubeState[i] = oldCubeState[i+27];
		cubeState[i+27] = oldCubeState[i];
	}
}

function scrambleCube() {
	// Do a bunch of random moves of the cube faces.
	for ( var i = 0; i < 50; i++ ) {
		var face = Math.floor(9*Math.random());
		var clockwise = ( Math.random() > .5 );
		rotateFace( face, clockwise );
	}
}

var solvingCube = false;
function solveCube() {
	// Optimize the log to get rid of unnecessary cube/face rotation.
	cubeChangeLog.optimize();
	
	// Cycle backwards through the log. Each entry is 4 chars long.
	if ( cubeChangeLog.numEntries() > 0 ) {
		solvingCube = true;
		solveCubeAnimation( 1, 400 );
	}
}

var solveCubeTimer;

function solveCubeAnimation( curEntryNum, delay ) {
	var curEntry = cubeChangeLog.getMostRecentEntry( curEntryNum );
	var command = curEntry.substring( 0, 2 );
	if ( command == "RF" ) {
		var faceNum = parseInt( curEntry.charAt(2) );
		var direction = parseInt( curEntry.charAt(3) );
		if ( direction == 0 ) {
			rotateFace( faceNum, true, true );
		}
		else {
			rotateFace( faceNum, false, true );
		}
	}
	else if ( command == "RC" ) {
		var fromFace = parseInt( curEntry.charAt( 2 ) );
		var toFace = parseInt( curEntry.charAt( 3 ) );
		rotateCube( toFace, fromFace, true );		// Do the opposite as was done before.
	}
	else {
		alert( "Error in command change log, command = " + command );
	}
	
	delay = Math.max( parseInt( delay*.95 ), 100 );
	drawCube();
	if ( curEntryNum < cubeChangeLog.numEntries() ) {
		solveCubeTimer = setTimeout( "solveCubeAnimation(" + (curEntryNum+1) + ", " + delay + " )", delay );
	}
	else {
		// Cube is solved, so erase the changelog.
		solvingCube = false;
		clearTimeout( solveCubeTimer );
		solveCubeTimer = null;
		cubeChangeLog.clear()
		fade( gleam, 0, 0.01, 500, function() { fade( gleam, 0, 1, 100, function() { fade( gleam, 1, 0, 400, function() { gleam.style.opacity = 0; } ); } ); } );
		solveButton.style.opacity = .4;   // Re-dim the "solve" button.
	}
}

var startX;
var startY;
var draggingUpDown;
var triggerHeight = 40;
var triggerWidth = 30;
var lastDiffx;
var lastDiffy;
var startedInImageNum;
var startedInImage;

function startDrag(e) {
	if ( ! solvingCube ) {
		// Register a mousemove event so we can detect what direction we're going in.
		startX = e.screenX;
		startY = e.screenY;
		draggingUpDown = -1;
		lastDiffx = 0;
		lastDiffy = 0;
		startedInImage = e.currentTarget;
		startedInImageNum = parseInt(e.currentTarget.id.substring(11));
		window.addEventListener('mousemove', whileDragging, false);
		window.addEventListener('mouseup', stopDrag, false );
	}
}

function whileDragging(e) {
	diffx = parseInt( (e.screenX - startX)/triggerWidth );
	diffy = parseInt( (e.screenY - startY)/triggerHeight );
	if ( draggingUpDown == -1 ) {
		if ( Math.abs(diffx) >= 1 ) {
			draggingUpDown = 0;
		}
		else if ( Math.abs(diffy) >= 1 ) {
			draggingUpDown = 1;
		}
	}
	
	// Figure out if we're going to rotate the cube or just a face.
	var rotateCubeFlag = e.altKey;
	
	// Dragging right/left
	if ( draggingUpDown == 0 ) {
		var doRotation = false;
		var rotateClockwise;
		if ( diffx > lastDiffx ) {
			// Rotate counter-clockwise.
			doRotation = true;
			rotateClockwise = false;
		}
		else if ( diffx < lastDiffx ) {
			// Rotate clockwise.
			doRotation = true;
			rotateClockwise = true;
		}
		if ( doRotation ) {
			lastDiffx = diffx;
			if ( ! rotateCubeFlag ) {
				var square = startedInImageNum % 9;
				if ( square < 3 ) {
					rotateFace( 0, rotateClockwise );
				}
				else if ( square < 6 ) {
					rotateFace( 8, rotateClockwise );
				}
				else {
					rotateFace( 3, !rotateClockwise );
				}
			}
			else {
				if ( rotateClockwise ) {
					rotateCube( 2, 1 );
				}
				else {
					rotateCube( 1, 2 );
				}
			}
			drawCube();
		}
	}
	
	// Dragging up/down
	else if ( draggingUpDown == 1 ) {
		var doRotation = false;
		var rotateClockwise;
		if ( diffy > lastDiffy ) {
			// Rotate counter-clockwise.
			doRotation = true;
			rotateClockwise = false;
		}
		else if ( diffy < lastDiffy ) {
			// Rotate clockwise.
			doRotation = true;
			rotateClockwise = true;
		}
		if ( doRotation ) {
			lastDiffy = diffy;
			var face = parseInt( startedInImageNum / 9 );
			if ( ! rotateCubeFlag ) {
				var square = startedInImageNum % 3;
				if ( face == 1 ) {
					if ( square == 0 ) {
						rotateFace( 4, !rotateClockwise );
					}
					else if ( square == 1 ) {
						rotateFace( 6, rotateClockwise );
					}
					else {
						rotateFace( 2, rotateClockwise );
					}
				}
				else if ( face == 2 ) {
					if ( square == 0 ) {
						rotateFace( 1, !rotateClockwise );
					}
					else if ( square == 1 ) {
						rotateFace( 7, !rotateClockwise );
					}
					else {
						rotateFace( 5, rotateClockwise );
					}
				}
				else {
					alert( "Serious error has happened. Face = " + face );
				}
			}
			else {
				if ( rotateClockwise ) {
					rotateCube( face, 0 );
				}
				else {
					rotateCube( 0, face );
				}				
			}
			drawCube();
		}	
	}
}

function stopDrag(e) {
	window.removeEventListener('mousemove', whileDragging, false );
	window.removeEventListener('mouseup', stopDrag, false );
}

function createKey( key ) {
	var newKey = widget.identifier + '-' + key;
	// alert( 'createKey() = ' + newKey );
	return( newKey );
}

function onremove() {
	// Delete all of the widget's preferences.
	widget.setPreferenceForKey( null, createKey( 'showMirrorState' ) );
	widget.setPreferenceForKey( null, createKey( 'appearanceState' ) );
	widget.setPreferenceForKey( null, createKey( 'colorSchemeName' ) );
	widget.setPreferenceForKey( null, createKey( 'cubeChangeLog' ) );
	widget.setPreferenceForKey( null, createKey( 'cubeState' ) );
}

var updateRequest;
function checkForUpdate() {

/*	alert( 'In checkForUpdate()' );
	updateRequest = new XMLHttpRequest();
	updateRequest.onload = processUpdateRequest;
	// updateRequest.onreadystatechange = processUpdateRequest;
	// updateRequest.overrideMimeType("text/xml");
	// updateRequest.setRequestHeader("Cache-Control", "no-cache");
	// var url = 'http://www.c3images.com/dashboard/latestCubeVersion.html';
	var url = 'http://apple.accuweather.com/adcbin/apple/Apple_Weather_Data.asp?zipcode=94107'
	updateRequest.open( 'GET', url );
	alert( 'url = ' + url );
	updateRequest.send( null );
*/
	var url = 'http://apple.accuweather.com/adcbin/apple/Apple_Weather_Data.asp?zipcode=94107';
	updateRequest = new XMLHttpRequest();
	updateRequest.onload = function(e) { processUpdateRequest(); }
	updateRequest.overrideMimeType("text/xml");
	updateRequest.open("GET", url );
	updateRequest.setRequestHeader("Cache-Control", "no-cache");
	updateRequest.setRequestHeader("wx", "385");
	updateRequest.send(null);
}

function processUpdateRequest() {
	alert( 'In processUpdateRequest(), readyState = ' + updateRequest.readyState );
	if ( updateRequest.readyState == 4 ) {
		alert( 'Headers = ' + updateRequest.getAllResponseHeaders() );
		if ( updateRequest.responseXML ) {
			alert( 'responseXML = true' );
			alert( 'responseXML.firstChild.nodeName = ' + updateRequest.responseXML.firstChild.nodeName );
			var versionNode = findChild( updateRequest.responseXML, 'version' );
			if ( versionNode )
				alert( 'versionNode data = ' + versionNode.data );
			else
				alert( 'versionNode = null' );
		}
		if ( updateRequest.status == 200 ) {
			alert( 'responseText = ' + updateRequest.responseText );
			latestVersionNumber = parseFloat( updateRequest.responseText );
			alert( 'latestVersionNumber = ' + latestVersionNumber );
			if ( latestVersionNumber > parseFloat( versionNumber ) ) {
				alert( 'An update is available!' );
			}
			else {
				alert( 'An update is not available!' );
			}
		}
		else {
			alert( 'Cube - Bad status code for update request: ' + updateRequest.status + ' ' + updateRequest.statusText );
		}
	}
}

function findChild (element, nodeName)
{
	var child;
	
	for (child = element.firstChild; child != null; child = child.nextSibling)
	{
		alert( 'child.nodeName = ' + child.nodeName );
		alert( 'child.data = ' + child.data );
		if (child.nodeName == nodeName)
			return child;
		if ( child.firstChild != null )
			return findChild( child.firstChild, nodeName );
	}
	
	return null;
}
